MERGE s61.sync_last_updates AS t
USING (SELECT 'table71' AS [source], 'table72' AS [target], COALESCE(MAX(last_update), 0) AS last_update FROM s61.table71) AS s ([source], [target], last_update)
ON (t.[source] = s.[source] AND t.[target] = s.[target])
WHEN MATCHED AND t.last_update = t.prev_update THEN
    UPDATE SET last_update = s.last_update
WHEN NOT MATCHED THEN  
    INSERT ([source], [target], last_update) VALUES (s.[source], s.[target], s.last_update);

MERGE s61.sync_last_updates AS t
USING (SELECT 'deleted_ints' AS [source], 'table72' AS [target], COALESCE(MAX(last_update), 0) AS last_update FROM s61.deleted_ints) AS s ([source], [target], last_update)
ON (t.[source] = s.[source] AND t.[target] = s.[target])
WHEN MATCHED AND t.last_update = t.prev_update THEN
    UPDATE SET last_update = s.last_update
WHEN NOT MATCHED THEN  
    INSERT ([source], [target], last_update) VALUES (s.[source], s.[target], s.last_update);
